--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- Represents 2D arrays of pixel values, as well as pyramids of multiple mipmap levels, each of 2D arrays of pixel values. Also contains information representing the format of the pixels and dimensions of the arrays.
--- @class niPixelData : niObject
--- @field bytesPerPixel number *Read-only*. The number of bytes per pixel.
--- @field mipMapLevels number *Read-only*. The number of MipMap levels.
niPixelData = {}

--- Creates a new NiPixelData object.
--- @param width number No description yet available.
--- @param height number No description yet available.
--- @param mipMapLevels? number *Default*: `1`. No description yet available.
--- @return niPixelData pixelData No description yet available.
function niPixelData.new(width, height, mipMapLevels) end

--- Creates a source texture from the current NiPixelData object.
--- @return niSourceTexture result No description yet available.
function niPixelData:createSourceTexture() end

--- Exports this pixel data as a Truevision TGA file. Only supports export of pixel data in RGBA32 format, which all `niPixelData` created using [`niPixelData.new`](https://mwse.github.io/MWSE/types/niPixelData/#new) are.
--- @param path string The path to write the file at, relative to the Morrowind installation folder. The `.tga` extension needs to be specified manually.
function niPixelData:exportTGA(path) end

--- Fills this pixel data with the provided color.
--- @param data number[] The color data to be set (1-indexed). The values should be in range [0.0, 1.0]. The first three values are RGB color channels, while the last one is alpha channel. The array length must be equal to the `bytesPerPixel` property of this niPixelData object, because alpha can be assigned only to the niPixelData object that has an alpha channel.
--- @param mipMapLevel? number *Default*: `0`. The mipmap level to fill with the provided color. The finest (largest) mipmap level is level 0.
function niPixelData:fill(data, mipMapLevel) end

--- Returns the height of the mipmap level at the given index, where level 1 is the finest (largest) mipmap level, and level `mipMapLevels` is the coarsest (smallest) mipmap level.
--- @param mipMapLevel? number *Default*: `1`. No description yet available.
--- @return number result No description yet available.
function niPixelData:getHeight(mipMapLevel) end

--- Returns the width of the mipmap level at the given index, where level 1 is the finest (largest) mipmap level, and level `mipMapLevels` is the coarsest (smallest) mipmap level.
--- @param mipMapLevel? number *Default*: `1`. No description yet available.
--- @return number result No description yet available.
function niPixelData:getWidth(mipMapLevel) end

--- Sets the pixel data from byte data.
--- @param data number[] The byte data to be set to (1-indexed).
--- @param mipMapLevel? number *Default*: `0`. The mipmap level whose data to modify. The finest (largest) mipmap level is level 0.
function niPixelData:setPixelsByte(data, mipMapLevel) end

--- Sets the pixel data from float data.
--- @param data number[] The float data to be set to (1-indexed). The values should be in range [0.0, 1.0].
--- @param mipMapLevel? number *Default*: `0`. The mipmap level whose data to modify. The finest (largest) mipmap level is level 0.
function niPixelData:setPixelsFloat(data, mipMapLevel) end

